/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.multistate;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import net.minecraft.world.item.ItemStack;

public final class MultiStateItemStackManager {
    private static final MultiStateItemStackManager INSTANCE = new MultiStateItemStackManager();
    private final Map<ItemStack, IMultiStateItemStack> itemStackToMultiStateItemStack = Collections.synchronizedMap(new WeakHashMap());

    public static MultiStateItemStackManager getInstance() {
        return INSTANCE;
    }

    private MultiStateItemStackManager() {
    }

    public IMultiStateItemStack getManagedStack(ItemStack itemStack, Function<ItemStack, IMultiStateItemStack> multiStateItemSupplier) {
        if (this.itemStackToMultiStateItemStack.containsKey(itemStack)) {
            return this.itemStackToMultiStateItemStack.get(itemStack);
        }
        IMultiStateItemStack multiStateItemStack = multiStateItemSupplier.apply(itemStack);
        this.itemStackToMultiStateItemStack.put(itemStack, multiStateItemStack);
        return multiStateItemStack;
    }
}

