/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftStackMessage {
    private final int slotNumber;

    public CraftStackMessage(int slotId) {
        this.slotNumber = slotId;
    }

    public static CraftStackMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new CraftStackMessage(slotNumber);
    }

    public static void encode(CraftStackMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, CraftStackMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.f_38839_.size()) {
            return;
        }
        Slot mouseSlot = (Slot)menu.f_38839_.get(message.slotNumber);
        ItemStack mouseStack = menu.m_142621_();
        for (int maxTries = 64; maxTries > 0 && mouseSlot.m_6657_() && (mouseStack.m_41619_() || mouseStack.m_41613_() + mouseSlot.m_7993_().m_41613_() <= mouseStack.m_41741_()); --maxTries) {
            menu.m_150399_(mouseSlot.f_40219_, 0, ClickType.PICKUP, (Player)player);
            mouseStack = menu.m_142621_();
        }
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-1, -1, -1, menu.m_142621_()));
    }
}

