from hook_loader import *
loadHookedModule('aiohttp')

import aiohttp, functools

_http_connection_init = aiohttp.ClientSession.__init__
@functools.wraps(_http_connection_init)
def _new_http_connection_init(self, *k, **kw):
  _http_connection_init(self, trust_env=True, *k, **kw)
aiohttp.ClientSession.__init__ = _new_http_connection_init

# Disable TLS-in-TLS if needed.
try:
  _tcp_connector_init = aiohttp.TCPConnector._loop_supports_start_tls
  @functools.wraps(_tcp_connector_init)
  def _new_tcp_connector_init(self, *k, **kw):
    return False
  aiohttp.TCPConnector._loop_supports_start_tls = _new_tcp_connector_init
except AttributeError:
  # No that function, skip it
  print('No TLS-in-TLS API found, skip it.')
