# Load origin module in overriding python modules.
def loadHookedModule(*modules):
  import sys, os
  # Get the path of the hooked module file.
  override_path = os.path.dirname(os.path.abspath(__file__))
  original_sys_path = list(sys.path)
  sys.path = [p for p in sys.path if p != override_path and p != '']

  # Delete overrided module from sys.modules and load the origin module.
  for mod in modules:
    if mod in sys.modules:
      del sys.modules[mod]
    __import__(mod)

  sys.path = original_sys_path