from hook_loader import *
loadHookedModule('http', 'http.client')

# Find proxy config in environment:
import os
httpProxy = os.environ['HTTP_PROXY']
[proxyHost, proxyPort] = httpProxy.split('://')[1].split(':')

from http.client import *
import functools

# Hook http connection initialization to tunnel through the proxy:
http_connection_init = HTTPConnection.__init__

@functools.wraps(http_connection_init)
def _new_http_connection_init(self, host, port=None, *k, **kw):
  http_connection_init(self, proxyHost, int(proxyPort), *k, **kw)
  self.set_tunnel(host, port)
HTTPConnection.__init__ = _new_http_connection_init

# Hook https connection initialization to tunnel through the proxy:
https_connection_init = HTTPSConnection.__init__

@functools.wraps(https_connection_init)
def _new_https_connection_init(self, host, port=None, *k, **kw):
  context = None
  if 'context' in kw:
    context = kw.get('context')
  elif len(k) > 7:
    context = k[7]
  if context == None:
    import ssl
    context = kw['context'] = ssl.SSLContext(ssl.PROTOCOL_SSLv23)

  # Load MITM CA cert:
  context.load_verify_locations(os.environ['SSL_CERT_FILE'])

  https_connection_init(self, proxyHost, int(proxyPort), *k, **kw)
  self.set_tunnel(host, port)
HTTPSConnection.__init__ = _new_https_connection_init