# Remove the directory containing this file from the LOAD_PATH
currentPath = File.expand_path(__dir__)
$LOAD_PATH.reject! { |path| File.expand_path(path) == currentPath }

require 'http'
module HTTP
  module ReqableHTTP
    def initialize(option)
      if not option[:proxy] or option[:proxy].keys.size < 2
        proxyEnv = URI(option.fetch(:uri).to_s).find_proxy
        option[:proxy] = {
          proxy_address: proxyEnv.host,
          proxy_port: proxyEnv.port
        }
      end
      super(option)
    end
  end

  class Request
    prepend ReqableHTTP
  end
end

$LOAD_PATH.unshift(currentPath)
