# Remove the directory containing this file from the default path
currentPath = File.expand_path('..', __dir__)
$LOAD_PATH.reject! { |path| File.expand_path(path) == currentPath }

require 'net/http'
module Net
  module ReqableHTTP
    def ca_file=(file)
      certPath = ENV['SSL_CERT_FILE']
      super(certPath)
    end

    def cert_store=(certStore)
      certPath = ENV['SSL_CERT_FILE']
      self.ca_file = certPath
    end

    def use_ssl=(value)
      certPath = ENV['SSL_CERT_FILE']
      self.ca_file = certPath
      super(value)
    end
  end

  # Override the HTTP class to inject the MITM certificate
  class HTTP
    prepend ReqableHTTP
  end
end

$LOAD_PATH.unshift(currentPath)